<?php

	function gen_all_cats() {

		$prefix=$GLOBALS['core']->tbl_prefix;

		$sql = "SELECT c.title, t.trans, c.cat_id ";
		$sql.= "FROM ${prefix}mod_fatcat_categories c ";
		$sql.= "LEFT JOIN ${prefix}mod_calendar_trans t ";
		$sql.= "ON c.cat_id=t.cat_id ";
		$sql.= "WHERE c.cat_id > 0 ";
		$sql.= "ORDER BY trans, title";

		return($GLOBALS['core']->getAllAssoc($sql)); 
	}



	function renderCatCheckbox($id, $checked) {

		$html = "<input type='checkbox' name='cat$id' ";
		$html.= "value='cat$id' ";

		if($checked)
			$html.= "checked=checked ";

		$html.= "/>";

		return($html);

	}


	function render_cats($data, $current, $last_view=null) {

		if(empty($data))
			return('<p>no categories!</p>');


		$html = "<form>";
		$html.= "<input type='hidden' name='module' value='calendar' />\n";

		if(isset($last_view))
			$html.= "<input type='hidden' name='calendar[view]' value='$last_view' />\n";

		$html.= "<table>\n";
		$html.= "<tr><th>view?</th><th>Category</th></tr>\n";

		if(isset($current))
			$cur_ar=explode(",", $current);

		foreach($data as $nr => $row) {

			$checked=false;
			$cat_id=$row['cat_id'];

			if(empty($current))
				$checked=true;
			else
				foreach($cur_ar as $nr2 => $val)
					if($cat_id == $val)
						$checked=true;

			$checkbox=renderCatCheckbox($cat_id, $checked);
			$name=$row['title'];

			if(isset($row['trans']))
				$name=$row['trans'];

			$html.="<tr><td>$checkbox</td>";
			$html.="<td>$name</td></tr>\n";

		}

		$html.= "</table>\n";
		$html.= "<br />";

		$html.= "<input type='submit' name='go' value='go' />\n";

		$html.= "</form>";

		return($html);

	}


	function request2comma($request) {

		$arr=array();

		foreach($request as $name => $value)
			if(strstr($name, "cat"))
				$arr[]=substr($name, 3);

		return($arr);

	}


	function CatSelect($current, $last_view) {

		$cats=gen_all_cats();
		$html = render_cats($cats, $current, $last_view);

		return($html);
	}

?>
