<?php
if (!isset($GLOBALS['core'])){
  header("location:../../");
  exit();
}

require_once(PHPWS_SOURCE_DIR . "mod/approval/class/Approval.php");

require_once(PHPWS_SOURCE_DIR . "mod/calendar/inc/CatSelect.php");
require_once(PHPWS_SOURCE_DIR . "mod/calendar/inc/CatMan.php");

$CNT_Calendar_Main["title"] = $CNT_Calendar_Main["content"] = NULL;
$calendarSettings = PHPWS_Calendar::getSettings();



	function all_set($filter) {

		if(empty($filter))
			return(false);

		$prefix=$GLOBALS['core']->tbl_prefix;

		$sql = 'SELECT count(cat_id) c ';
		$sql.= "FROM ${prefix}mod_fatcat_categories ";
		$sql.= 'WHERE cat_id > 0';

		$data=$GLOBALS['core']->getAllAssoc($sql);
		$count=$data[0]['c'];

		return(sizeof($filter)>=$count);
	}




	function gen_showcat_sql($what=null) {

		$prefix=$GLOBALS['core']->tbl_prefix;

		$sql ='SELECT cat.cat_id, tr.trans, ev.title event, cat.title category ';
		$sql.="FROM ${prefix}mod_calendar_events ev, ";
		$sql.=		"${prefix}mod_fatcat_elements el, ";
		$sql.=		"${prefix}mod_fatcat_categories cat ";
		$sql.=		" LEFT JOIN ${prefix}mod_calendar_trans tr ";
		$sql.=		" ON tr.cat_id=cat.cat_id ";
		$sql.='WHERE el.module_id=ev.id AND ';
		$sql.=		'cat.cat_id=el.cat_id AND ';
		$sql.=		'el.module_title="calendar" ';

		if(isset($what))
			$sql.=	"AND cat.cat_id='$what'";

		return($sql);

	}


	function get_showcat_data($what) {
		if($what == 'all')
			$sql=gen_showcat_sql();
		else
			$sql=gen_showcat_sql($what);

		return($GLOBALS['core']->getAllAssoc($sql));
	}


	function render_showcat_data($data) {

		if(sizeof($data)==0)
			return('no data!');

		$html ="<table>\n";
		$html.="<tr><th>Category</th><th>Translated</th><th>Event</th></tr>\n";

		foreach($data as $nr => $row) {

			$cat_id=$row['cat_id'];
			$category=$row['category'];
			$event=$row['event'];

			$trans=$row['trans'];
			if(empty($trans))
				$trans=$category;

			$html.="<tr><td>$cat_id: $category</td>";
			$html.="<td>$trans</td><td>$event</td></tr>\n";

		}

		$html.="</table>\n";

		return($html);

	}



	function show_cat($cat) {

		$data=get_showcat_data($cat);
		return(render_showcat_data($data));
	}



	function handle_admin_functions($command) {

		global $_SESSION, $_REQUEST, $_GET, $CNT_Calendar_Main, $core;

		switch ($command){

			case "admin_menu":
				$_SESSION["CreateEvent"] = new PHPWS_Calendar_Event;
				PHPWS_Calendar_Forms::createEventForm($_SESSION["CreateEvent"]);

				break;


			case "createEventForm":
				$_SESSION["CreateEvent"] = new PHPWS_Calendar_Event;
				PHPWS_Calendar_Forms::createEventForm($_SESSION["CreateEvent"]);

				break;


			case "createEventAction":

				if (isset($_SESSION["CreateEvent"])){

					if ($_SESSION["CreateEvent"]->processEvent()){

						$_SESSION["CreateEvent"]->writeEvent();

						$CNT_Calendar_Main["title"] =
							$_SESSION["translate"]->it("Event created successfully")."!";

						$CNT_Calendar_Main["content"] .=
							PHPWS_Calendar_Display::viewEvent($_SESSION['CreateEvent']->id);

						$core->killSession("CreateEvent");
						PHPWS_Calendar::resetCache();

					} else {
						$CNT_Calendar_Main["content"] .=
							$_SESSION["CreateEvent"]->printErrors();

						PHPWS_Calendar_Forms::createEventForm($_SESSION["CreateEvent"]);
					}
				}

				break;


			case "editEvent":

				$_SESSION["EditEvent"] = new PHPWS_Calendar_Event((int)$_REQUEST["id"]);
				PHPWS_Calendar_Forms::editEventForm($_SESSION["EditEvent"]);

				break;


			case "deleteEvent":
				PHPWS_Calendar_Forms::deleteEventForm(
					(int)$_REQUEST["id"],
					isset($_REQUEST["confirm"]) ? (int)$_REQUEST["confirm"] : NULL);

				PHPWS_Calendar::resetCache();

				break;


			case "editEventAction":

				if ($_SESSION["EditEvent"]){
					if ($_SESSION["EditEvent"]->processEvent()){

						$_SESSION["EditEvent"]->updateEvent();
						PHPWS_Calendar::resetCache();

						$CNT_Calendar_Main["title"] =
							$_SESSION["translate"]->it("Event updated successfully")."!";

						$CNT_Calendar_Main["content"] =
							PHPWS_Calendar_Display::viewEvent($_SESSION['EditEvent']->id);

						$core->killSession("EditEvent");

					} else {

						$CNT_Calendar_Main["content"] .= $_SESSION["EditEvent"]->printErrors();
						PHPWS_Calendar_Forms::editEventForm($_SESSION["EditEvent"]);
					}
				}

				break;


			case "settings":

				$CNT_Calendar_Main["title"]   = $_SESSION["translate"]->it("Calendar Settings");
				$CNT_Calendar_Main["content"] = PHPWS_Calendar_Forms::settings();
				
				break;

			case "updateSettings":

				PHPWS_Calendar::updateSettings();
				PHPWS_Calendar::resetCache();

				$CNT_Calendar_Main["title"] = $_SESSION["translate"]->it("Calendar Settings");
				$CNT_Calendar_Main["content"] = "<b>" . $_SESSION["translate"]->it("Settings Updated") . "!</b>";

				$CNT_Calendar_Main["content"] .= PHPWS_Calendar_Forms::settings();

				break;

			default:
				break;

		} // End admin command switch
	}



	function handle_user_functions($command) {

		global $_SESSION, $_REQUEST, $_GET, $CNT_Calendar_Main, $core;

		switch ($command){

			case "changeBoxMonth":
				PHPWS_Calendar_Display::setBoxMonth((int)$_GET["month"], (int)$_GET["year"]);
				header("location:./" . preg_replace("/.*(index\.php.*|)$/Ui", "\\1", $_SERVER['HTTP_REFERER']));
				exit();
			break;

			case "userEvent":
				if ($calendarSettings["userSubmit"]){
					$_SESSION["CreateUserEvent"] = new PHPWS_Calendar_Event;
					PHPWS_Calendar_Forms::createUserEventForm($_SESSION["CreateUserEvent"]);
				}
			break;

			case "createUserEventAction":

				if ($_SESSION["CreateUserEvent"]){

					if ($_SESSION["CreateUserEvent"]->processEvent()){

						$_SESSION["CreateUserEvent"]->writeEvent();
						PHPWS_Approval::add($_SESSION["CreateUserEvent"]->id,
							$_SESSION["CreateUserEvent"]->title);

						$GLOBALS['core']->killSession("CreateUserEvent");

						PHPWS_Calendar::resetCache();
						$CNT_Calendar_Main["content"] .=
							$_SESSION["translate"]->it("Event submitted for approval").".";

					} else {

						$CNT_Calendar_Main["content"] .=
						$_SESSION["CreateUserEvent"]->printErrors();

						PHPWS_Calendar_Forms::createUserEventForm($_SESSION["CreateUserEvent"]);
					}
				}
			break;

			case "reset":
				PHPWS_Calendar::resetCache();
				header("location:./" . preg_replace("/.*(index\.php.*|)$/Ui", "\\1", $_SERVER["HTTP_REFERER"]));
				exit();
			break;

		} // End user command switch

	}


	function handle_view($command, $filter) {

		if(strlen(trim($filter))>0)
			$filter=explode(",", $filter);

		global $_REQUEST, $CNT_Calendar_Main;

		$yearSet  = $_REQUEST['year'];
		$monthSet = $_REQUEST['month'];
		$daySet   = $_REQUEST['day'];
		$weekSet   = $_REQUEST['week'];

		switch ($command){
			case "year":
				$CNT_Calendar_Main["content"] = PHPWS_Calendar_Display::viewYear($yearSet, $filter);
			break;

			case "month":
				$CNT_Calendar_Main["content"] = PHPWS_Calendar_Display::viewMonth($yearSet, $monthSet, $filter);
			break;

			case "day":
				$CNT_Calendar_Main["content"] = PHPWS_Calendar_Display::viewDay($yearSet, $monthSet, $daySet, $filter);
			break;

			case "week":
				$CNT_Calendar_Main["content"] = PHPWS_Calendar_Display::viewWeek($yearSet, $monthSet, $weekSet, $filter);
			break;

			case "event":
				$eventcontent = PHPWS_Calendar_Display::viewEvent((int)$_REQUEST["id"],
					(isset($_REQUEST["date"])) ? (int)$_REQUEST["date"] : NULL);

				if (!$eventcontent)
					$CNT_Calendar_Main["content"] = $_SESSION["translate"]->it("This event is no longer listed") . ".";
				else
					$CNT_Calendar_Main["content"].= $eventcontent;
			break;

			case "minievent":
				echo PHPWS_Calendar_Display::viewMiniEvent((int)$_REQUEST["id"]);

			break;
		}
	}



	function set_up_filter() {

		global $_SESSION, $_REQUEST, $CNT_Calendar_Main;

		$filter=$_REQUEST['fatcat_id'];


		if(isset($filter)) {

			if($filter == 'all')
				$_SESSION['cal_filter']=$filter;
			else
				unset($_SESSION['cal_filter']);

		} else
			$filter=$_SESSION['cal_filter'];


		if (isset($_REQUEST['module']) && $_REQUEST['module'] == 'calendar' && isset($_REQUEST['go'])) {

			// $CNT_Calendar_Main['title']="You've selected";
			$filter=request2comma($_REQUEST);
			if(isset($filter)) {
				$_SESSION['cal_filter']=$filter;
				$CNT_Calendar_Main['content']="Cat-IDs ".implode(", ", $filter);

			} else {
				unset($_SESSION['cal_filter']);
				$CNT_Calendar_Main['content']="Everything";
			}
		}

		if(all_set($filter))
			unset($filter);

		if(isset($filter))
			$filter=implode(",", $filter);

		return($filter);
	}






	$filter=set_up_filter();
	
	if (isset($_REQUEST['module']) && $_REQUEST['module'] == 'calendar' && isset($_REQUEST['cat_man'])) {

		$CNT_Calendar_Main['title']='category manager';
		$CNT_Calendar_Main['content']=CatMan($_REQUEST);

	} else
	if (isset($_REQUEST['module']) && $_REQUEST['module'] == 'calendar' && isset($_REQUEST['show_cat'])) {

		$CNT_Calendar_Main['title']='showing categories';
		$CNT_Calendar_Main['content']=show_cat($_REQUEST['show_cat']);

	} else
	if (isset($_REQUEST['module']) && $_REQUEST['module'] == 'calendar' && isset($_REQUEST['cat_select'])) {

		$CNT_Calendar_Main['title']='please select your categories';
		$CNT_Calendar_Main['content']=CatSelect($filter, $_REQUEST['old_view']);

	}
	if (isset($_REQUEST["module"]) && $_REQUEST["module"] == "calendar"){


		PHPWS_Calendar::panel();
	  
		if ($calCommand = $_REQUEST["calendar"])
			foreach ($calCommand as $section=>$command);

		if ($section == "admin" && $_SESSION["OBJ_user"]->allow_access("calendar"))

			 handle_admin_functions($command);

		else
		if ($section == "user")

			 handle_user_functions($command);

		else
		if($section == "view")
			handle_view($command, $filter);

	}

?>
